<?php
/* 
 * ARI Stream Quiz Theme "Rounded"
 * Version: 1.1
 * Author:  Hiyoshi-it.com
 */
 
namespace Ari_Stream_Quiz_Themes\Rounded;

use Ari_Stream_Quiz_Themes\Loader as Loader_Base;

class Loader extends Loader_Base {
	protected $name = 'rounded';

	public function init() {
		wp_enqueue_style( 
			'ari-quiz-rounded-theme-font', 
			'https://fonts.googleapis.com/css?family=M+PLUS+Rounded+1c:400' 
		);

		$theme_css_file = ARISTREAMQUIZ_THEMES_URL . $this->name . '/css/theme.css';
		$theme_js_file  = ARISTREAMQUIZ_THEMES_URL . $this->name . '/js/theme.js';
		wp_enqueue_style( 'ari-quiz-theme-rounded', $theme_css_file, array(), '0.9' );
		wp_enqueue_script( 'ari-quiz-theme-rounded-js', $theme_js_file, array(), '0.1', true );
	}
}
